/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.mixin.entity.IMixinMerchantEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.InventoryOverlayContext;
import fi.dy.masa.malilib.render.InventoryOverlayType;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataBlockUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;

public class InventoryOverlayScreen
extends Screen
implements Renderable {
    String modId;
    private InventoryOverlay.Context previewData;
    private InventoryOverlayContext previewDataNew;
    private final boolean shulkerBGColors;
    private final boolean villagerBGColors;
    private int ticks;

    @Deprecated
    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData) {
        this(modId, previewData, true, false);
    }

    @Deprecated
    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData, boolean shulkerBGColors) {
        this(modId, previewData, shulkerBGColors, false);
    }

    @Deprecated
    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData, boolean shulkerBGColors, boolean villagerBGColors) {
        super(StringUtils.translateAsText("malilib.gui.title.inventory_overlay", modId));
        this.modId = modId;
        this.previewData = previewData;
        this.previewDataNew = null;
        this.shulkerBGColors = shulkerBGColors;
        this.villagerBGColors = villagerBGColors;
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlayContext previewData) {
        this(modId, previewData, true, false);
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlayContext previewData, boolean shulkerBGColors) {
        this(modId, previewData, shulkerBGColors, false);
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlayContext previewData, boolean shulkerBGColors, boolean villagerBGColors) {
        super(StringUtils.translateAsText("malilib.gui.title.inventory_overlay", modId));
        this.modId = modId;
        this.previewData = null;
        this.previewDataNew = previewData;
        this.shulkerBGColors = shulkerBGColors;
        this.villagerBGColors = villagerBGColors;
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.previewData != null) {
            this.renderNbt(drawContext, mouseX, mouseY, delta);
        } else if (this.previewDataNew != null) {
            this.renderData(drawContext, mouseX, mouseY, delta);
        }
    }

    @Deprecated
    private void renderNbt(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        ++this.ticks;
        Minecraft mc = Minecraft.getInstance();
        Level world = WorldUtils.getBestWorld(mc);
        if (this.previewData != null && world != null) {
            Block block;
            BlockEntity blockEntity;
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            int x = xCenter - 26;
            int y = yCenter - 92;
            int startSlot = 0;
            int totalSlots = this.previewData.inv() == null ? 0 : this.previewData.inv().getContainerSize();
            ArrayList<ItemStack> armourItems = new ArrayList<ItemStack>();
            if (this.previewData.entity() instanceof AbstractHorse) {
                if (this.previewData.inv() == null) {
                    MaLiLib.LOGGER.warn("renderNbt(): Horse inv() = null");
                    return;
                }
                armourItems.add(this.previewData.entity().getItemBySlot(EquipmentSlot.BODY));
                armourItems.add(this.previewData.inv().getItem(0));
                startSlot = 1;
                totalSlots = this.previewData.inv().getContainerSize() - 1;
            } else if (this.previewData.entity() instanceof Wolf || this.previewData.entity() instanceof HappyGhast) {
                armourItems.add(this.previewData.entity().getItemBySlot(EquipmentSlot.BODY));
            } else if (this.previewData.entity() instanceof CopperGolem) {
                armourItems.add(this.previewData.entity().getItemBySlot(EquipmentSlot.SADDLE));
            }
            InventoryOverlay.InventoryRenderType type = this.previewData.entity() instanceof Villager ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType(this.previewData.inv(), this.previewData.nbt() != null ? this.previewData.nbt() : new CompoundTag(), this.previewData);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            HashSet<Integer> lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (MaLiLibReference.DEBUG_MODE) {
                MaLiLib.LOGGER.warn("renderNbt():0: type [{}], previewData.type [{}], previewData.inv [{}], previewData.be [{}], previewData.ent [{}], previewData.nbt [{}]", (Object)type.toString(), (Object)this.previewData.type().toString(), (Object)(this.previewData.inv() != null ? 1 : 0), (Object)(this.previewData.be() != null ? 1 : 0), (Object)(this.previewData.entity() != null ? 1 : 0), this.previewData.nbt() != null ? this.previewData.nbt().getString("id").orElse("[invalid]") : null);
                MaLiLib.LOGGER.error("0: -> inv.type [{}] // nbt.type [{}]", (Object)(this.previewData.inv() != null ? InventoryOverlay.getInventoryType(this.previewData.inv()) : null), this.previewData.nbt() != null ? InventoryOverlay.getInventoryType(this.previewData.nbt()) : null);
                MaLiLib.LOGGER.error("1: -> inv.size [{}] // inv.isEmpty [{}]", (Object)(this.previewData.inv() != null ? this.previewData.inv().getContainerSize() : -1), (Object)(this.previewData.inv() != null ? (Comparable<Boolean>)Boolean.valueOf(this.previewData.inv().isEmpty()) : (Comparable<Boolean>)Integer.valueOf(-1)));
                MaLiLib.LOGGER.error("2: -> total slots [{}] // rows [{}] // startSlot [{}]", (Object)totalSlots, (Object)rows, (Object)startSlot);
            }
            if (this.previewData.entity() != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if ((blockEntity = this.previewData.be()) instanceof CrafterBlockEntity) {
                CrafterBlockEntity cbe = (CrafterBlockEntity)blockEntity;
                lockedSlots = BlockUtils.getDisabledSlots(cbe);
            } else if (this.previewData.nbt() != null && this.previewData.nbt().contains("disabled_slots")) {
                lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(this.previewData.nbt());
            }
            if (!armourItems.isEmpty()) {
                SimpleContainer horseInv = new SimpleContainer(armourItems.toArray(new ItemStack[0]));
                InventoryOverlay.renderInventoryBackground(drawContext, type, xInv, yInv, 1, horseInv.getContainerSize(), mc);
                InventoryOverlay.renderInventoryBackgroundSlots(drawContext, type, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
                InventoryOverlay.renderInventoryStacks(drawContext, type, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, horseInv.getContainerSize(), mc, mouseX, mouseY);
                xInv += 36;
            }
            int color = -1;
            if (this.previewData.be() != null && (block = this.previewData.be().getBlockState().getBlock()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock sbb = (ShulkerBoxBlock)block;
                color = RenderUtils.setShulkerboxBackgroundTintColor(sbb, this.shulkerBGColors);
            }
            if (totalSlots > 0 && this.previewData.inv() != null) {
                InventoryOverlay.renderInventoryBackground(drawContext, type, xInv, yInv, props.slotsPerRow, totalSlots, color, mc);
                if (type == InventoryOverlay.InventoryRenderType.BREWING_STAND) {
                    InventoryOverlay.renderBrewerBackgroundSlots(drawContext, this.previewData.inv(), xInv, yInv);
                }
                InventoryOverlay.renderInventoryStacks(drawContext, type, this.previewData.inv(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, props.slotsPerRow, startSlot, totalSlots, lockedSlots, mc, mouseX, mouseY);
            }
            if ((this.previewData.type() == InventoryOverlay.InventoryRenderType.PLAYER || type == InventoryOverlay.InventoryRenderType.ENDER_CHEST) && this.previewData.nbt() != null && this.previewData.nbt().contains("EnderItems")) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromNbt(this.previewData.nbt(), world.registryAccess());
                if (enderItems == null) {
                    enderItems = new PlayerEnderChestContainer();
                }
                yInv = yCenter + 6;
                InventoryOverlay.renderInventoryBackground(drawContext, InventoryOverlay.InventoryRenderType.GENERIC, xInv, yInv, 9, 27, color, mc);
                InventoryOverlay.renderInventoryStacks(drawContext, InventoryOverlay.InventoryRenderType.GENERIC, (Container)enderItems, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mc, mouseX, mouseY);
            } else {
                enderItems = this.previewData.entity();
                if (enderItems instanceof Player) {
                    Player player = (Player)enderItems;
                    yInv = yCenter + 6;
                    InventoryOverlay.renderInventoryBackground(drawContext, InventoryOverlay.InventoryRenderType.GENERIC, xInv, yInv, 9, 27, color, mc);
                    InventoryOverlay.renderInventoryStacks(drawContext, InventoryOverlay.InventoryRenderType.GENERIC, (Container)player.getEnderChestInventory(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mc, mouseX, mouseY);
                }
            }
            if (type == InventoryOverlay.InventoryRenderType.VILLAGER && this.previewData.nbt() != null && this.previewData.nbt().contains("Offers")) {
                offers = InventoryUtils.getSellingItemsFromNbt(this.previewData.nbt(), world.registryAccess());
                Container tradeOffers = InventoryUtils.getAsInventory(offers);
                if (tradeOffers != null && !tradeOffers.isEmpty()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    color = RenderUtils.setVillagerBackgroundTintColor(NbtEntityUtils.getVillagerDataFromNbt(this.previewData.nbt()), this.villagerBGColors);
                    InventoryOverlay.renderInventoryBackground(drawContext, InventoryOverlay.InventoryRenderType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, color, mc);
                    InventoryOverlay.renderInventoryStacks(drawContext, InventoryOverlay.InventoryRenderType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mc, mouseX, mouseY);
                }
            } else {
                AbstractVillager merchant;
                MerchantOffers trades;
                NonNullList<ItemStack> offers;
                Container tradeOffers;
                offers = this.previewData.entity();
                if (offers instanceof AbstractVillager && (tradeOffers = InventoryUtils.getAsInventory(offers = (trades = ((IMixinMerchantEntity)(merchant = (AbstractVillager)offers)).malilib_offers()) != null ? InventoryUtils.getSellingItems(trades) : NonNullList.create())) != null && !tradeOffers.isEmpty()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    if (merchant instanceof Villager) {
                        Villager villager = (Villager)merchant;
                        color = RenderUtils.setVillagerBackgroundTintColor(villager.getVillagerData(), this.villagerBGColors);
                    }
                    InventoryOverlay.renderInventoryBackground(drawContext, InventoryOverlay.InventoryRenderType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, color, mc);
                    InventoryOverlay.renderInventoryStacks(drawContext, InventoryOverlay.InventoryRenderType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mc, mouseX, mouseY);
                }
            }
            if (this.previewData.entity() != null) {
                InventoryOverlay.renderEquipmentOverlayBackground(drawContext, x, y, this.previewData.entity());
                InventoryOverlay.renderEquipmentStacks(drawContext, this.previewData.entity(), x, y, mc, mouseX, mouseY);
            }
            if (this.ticks % 4 == 0) {
                this.previewData = this.previewData.handler().onContextRefresh(this.previewData, world);
            }
        }
    }

    private void renderData(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        ++this.ticks;
        Minecraft mc = Minecraft.getInstance();
        Level world = WorldUtils.getBestWorld(mc);
        if (this.previewDataNew != null && world != null) {
            Block block;
            BlockEntity blockEntity;
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            int x = xCenter - 26;
            int y = yCenter - 92;
            int startSlot = 0;
            int totalSlots = this.previewDataNew.inv() == null ? 0 : this.previewDataNew.inv().getContainerSize();
            ArrayList<ItemStack> armourItems = new ArrayList<ItemStack>();
            if (this.previewDataNew.entity() instanceof AbstractHorse) {
                if (this.previewDataNew.inv() == null) {
                    MaLiLib.LOGGER.warn("renderData(): Horse inv() = null");
                    return;
                }
                armourItems.add(this.previewDataNew.entity().getItemBySlot(EquipmentSlot.BODY));
                armourItems.add(this.previewDataNew.inv().getItem(0));
                startSlot = 1;
                totalSlots = this.previewDataNew.inv().getContainerSize() - 1;
            } else if (this.previewDataNew.entity() instanceof Wolf || this.previewDataNew.entity() instanceof HappyGhast) {
                armourItems.add(this.previewDataNew.entity().getItemBySlot(EquipmentSlot.BODY));
            } else if (this.previewDataNew.entity() instanceof CopperGolem) {
                armourItems.add(this.previewDataNew.entity().getItemBySlot(EquipmentSlot.SADDLE));
            }
            InventoryOverlayType type = this.previewDataNew.entity() instanceof Villager ? InventoryOverlayType.VILLAGER : InventoryOverlay.getBestInventoryTypeNew(this.previewDataNew.inv(), this.previewDataNew.data() != null ? this.previewDataNew.data() : new CompoundData(), this.previewDataNew);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTempNew(type, totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            HashSet<Integer> lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (MaLiLibReference.DEBUG_MODE) {
                MaLiLib.LOGGER.warn("renderData():0: type [{}], previewData.type [{}], previewData.inv [{}], previewData.be [{}], previewData.ent [{}], previewData.data [{}]", (Object)type.toString(), (Object)this.previewDataNew.type().toString(), (Object)(this.previewDataNew.inv() != null ? 1 : 0), (Object)(this.previewDataNew.be() != null ? 1 : 0), (Object)(this.previewDataNew.entity() != null ? 1 : 0), this.previewDataNew.data() != null ? this.previewDataNew.data().getString("id") : null);
                MaLiLib.LOGGER.error("0: -> inv.type [{}] // data.type [{}]", (Object)(this.previewDataNew.inv() != null ? InventoryOverlay.getInventoryTypeNew(this.previewDataNew.inv()) : null), this.previewDataNew.data() != null ? InventoryOverlay.getInventoryTypeNew(this.previewDataNew.data()) : null);
                MaLiLib.LOGGER.error("1: -> inv.size [{}] // inv.isEmpty [{}]", (Object)(this.previewDataNew.inv() != null ? this.previewDataNew.inv().getContainerSize() : -1), (Object)(this.previewDataNew.inv() != null ? (Comparable<Boolean>)Boolean.valueOf(this.previewDataNew.inv().isEmpty()) : (Comparable<Boolean>)Integer.valueOf(-1)));
                MaLiLib.LOGGER.error("2: -> total slots [{}] // rows [{}] // startSlot [{}]", (Object)totalSlots, (Object)rows, (Object)startSlot);
            }
            if (this.previewDataNew.entity() != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if ((blockEntity = this.previewDataNew.be()) instanceof CrafterBlockEntity) {
                CrafterBlockEntity cbe = (CrafterBlockEntity)blockEntity;
                lockedSlots = BlockUtils.getDisabledSlots(cbe);
            } else if (this.previewDataNew.data() != null && this.previewDataNew.data().contains("disabled_slots", 11)) {
                lockedSlots = DataBlockUtils.getDisabledSlots(this.previewDataNew.data());
            }
            if (!armourItems.isEmpty()) {
                SimpleContainer horseInv = new SimpleContainer(armourItems.toArray(new ItemStack[0]));
                InventoryOverlay.renderInventoryBackgroundNew(drawContext, type, xInv, yInv, 1, horseInv.getContainerSize(), mc);
                InventoryOverlay.renderInventoryBackgroundSlotsNew(drawContext, type, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
                InventoryOverlay.renderInventoryStacksNew(drawContext, type, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, horseInv.getContainerSize(), mc, mouseX, mouseY);
                xInv += 36;
            }
            int color = -1;
            if (this.previewDataNew.be() != null && (block = this.previewDataNew.be().getBlockState().getBlock()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock sbb = (ShulkerBoxBlock)block;
                color = RenderUtils.setShulkerboxBackgroundTintColor(sbb, this.shulkerBGColors);
            }
            if (totalSlots > 0 && this.previewDataNew.inv() != null) {
                InventoryOverlay.renderInventoryBackgroundNew(drawContext, type, xInv, yInv, props.slotsPerRow, totalSlots, color, mc);
                if (type == InventoryOverlayType.BREWING_STAND) {
                    InventoryOverlay.renderBrewerBackgroundSlots(drawContext, this.previewDataNew.inv(), xInv, yInv);
                }
                InventoryOverlay.renderInventoryStacksNew(drawContext, type, this.previewDataNew.inv(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, props.slotsPerRow, startSlot, totalSlots, lockedSlots, mc, mouseX, mouseY);
            }
            if ((this.previewDataNew.type() == InventoryOverlayType.PLAYER || type == InventoryOverlayType.ENDER_CHEST) && this.previewDataNew.data() != null && this.previewDataNew.data().contains("EnderItems", 9)) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromData(this.previewDataNew.data(), world.registryAccess());
                if (enderItems == null) {
                    enderItems = new PlayerEnderChestContainer();
                }
                MaLiLib.LOGGER.error("renderData(): enderItems [{}]", (Object)enderItems.getContainerSize());
                yInv = yCenter + 6;
                InventoryOverlay.renderInventoryBackgroundNew(drawContext, InventoryOverlayType.GENERIC, xInv, yInv, 9, 27, color, mc);
                InventoryOverlay.renderInventoryStacksNew(drawContext, InventoryOverlayType.GENERIC, (Container)enderItems, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mc, mouseX, mouseY);
            } else {
                enderItems = this.previewDataNew.entity();
                if (enderItems instanceof Player) {
                    Player player = (Player)enderItems;
                    yInv = yCenter + 6;
                    InventoryOverlay.renderInventoryBackgroundNew(drawContext, InventoryOverlayType.GENERIC, xInv, yInv, 9, 27, color, mc);
                    InventoryOverlay.renderInventoryStacksNew(drawContext, InventoryOverlayType.GENERIC, (Container)player.getEnderChestInventory(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mc, mouseX, mouseY);
                }
            }
            if (type == InventoryOverlayType.VILLAGER && this.previewDataNew.data() != null && this.previewDataNew.data().contains("Offers", 9)) {
                offers = InventoryUtils.getSellingItemsFromData(this.previewDataNew.data(), world.registryAccess());
                Container tradeOffers = InventoryUtils.getAsInventory(offers);
                if (tradeOffers != null && !tradeOffers.isEmpty()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    color = RenderUtils.setVillagerBackgroundTintColor(DataEntityUtils.getVillagerData(this.previewDataNew.data()), this.villagerBGColors);
                    InventoryOverlay.renderInventoryBackgroundNew(drawContext, InventoryOverlayType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, color, mc);
                    InventoryOverlay.renderInventoryStacksNew(drawContext, InventoryOverlayType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mc, mouseX, mouseY);
                }
            } else {
                AbstractVillager merchant;
                MerchantOffers trades;
                NonNullList<ItemStack> offers;
                Container tradeOffers;
                offers = this.previewDataNew.entity();
                if (offers instanceof AbstractVillager && (tradeOffers = InventoryUtils.getAsInventory(offers = (trades = ((IMixinMerchantEntity)(merchant = (AbstractVillager)offers)).malilib_offers()) != null ? InventoryUtils.getSellingItems(trades) : NonNullList.create())) != null && !tradeOffers.isEmpty()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    if (merchant instanceof Villager) {
                        Villager villager = (Villager)merchant;
                        color = RenderUtils.setVillagerBackgroundTintColor(villager.getVillagerData(), this.villagerBGColors);
                    }
                    InventoryOverlay.renderInventoryBackgroundNew(drawContext, InventoryOverlayType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, color, mc);
                    InventoryOverlay.renderInventoryStacksNew(drawContext, InventoryOverlayType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mc, mouseX, mouseY);
                }
            }
            if (this.previewDataNew.entity() != null) {
                InventoryOverlay.renderEquipmentOverlayBackground(drawContext, x, y, this.previewDataNew.entity());
                InventoryOverlay.renderEquipmentStacks(drawContext, this.previewDataNew.entity(), x, y, mc, mouseX, mouseY);
            }
            if (this.ticks % 4 == 0) {
                this.previewDataNew = this.previewDataNew.refresher().onContextRefresh(this.previewDataNew, world);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

